﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Utilities;
using System.Data;

namespace AZVIC.Ei8htPOS.Entities
{
    public class OrdersPayment : BusinessBaseClass
    {
        public OrdersPayment()
        {
        }

        public OrdersPayment(IDataReader myDataRecord)
        {
            UniqueID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("OrdersPaymentID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("OrdersPaymentID"));
            OrdersID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("OrdersID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("OrdersID"));
            PaidAmount = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PaidAmount")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("PaidAmount"));
            PaymentMethod = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PaymentMethod")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("PaymentMethod"));
            PaymentType = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PaymentType")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("PaymentType"));
            PaymentStatus = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PaymentStatus")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("PaymentStatus"));
            TransactionReference = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TransactionReference")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("TransactionReference"));
            Comments = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Comments")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Comments"));
            AdminUserAccountID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedBy")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("CreatedBy"));
            CreatedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("CreatedDate"));
            ModifiedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("ModifiedDate"));
            IsActive = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsActive")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsActive"));
            //IsDeleted = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsDeleted")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsDeleted"));
        }

        [DataObjectField(true, false, false)]
        public override Guid UniqueID { get; set; }

        public Guid OrdersID { get; set; }

        public decimal PaidAmount { get; set; }

        public string PaymentMethod { get; set; }

        public string PaymentType { get; set; }

        public string PaymentStatus { get; set; }

        public string TransactionReference { get; set; }

        public string Comments { get; set; }

        public Guid AdminUserAccountID { get; set; }

        public override DateTime CreatedDate { get; set; }

        public override DateTime ModifiedDate { get; set; }

        public override GlobalConfigurations.Mode Mode { get; set; }

        public override bool IsActive { get; set; }

        //public override bool IsDeleted { get; set; }

        public OCBCHelper.OCBCTransactionResponse OCBCResponse;

        public NETSHelper.TransactionResponse NETSResponse;
    }
}
